#ifndef __MT_LIST_WINDOW_H__
#define __MT_LIST_WINDOW_H__

#include "MTWindow.h"
#include "MTUtilities.h"

enum
{
	kListItemSelectedFlag =	1 << 0
};

class MTListWindow : public MTWindow
{
	public:
						MTListWindow();
		virtual			~MTListWindow();
		
		void			HandleOpenEvent(void);
		void			HandleCloseEvent(void);
		void			HandleContentEvent(EventRecord * theEvent, UInt32 flags);
		void			HandleResizeEvent(SInt32 newWidth, SInt32 newHeight);
		void			HandleUpdateEvent(void);
		
		void			HandleScrollEvent(MTWindowControlType which, SInt32 value);
		void			HandleControlEvent(ControlHandle theControl, SInt16 thePart);
		void			HandleButtonEvent(ControlHandle theControl);
		
		virtual UInt8	IsUniqueWindow(void) = 0;
		
		virtual void	GetWindowName(StringPtr theString) = 0;
	
	protected:
		void			GetZoomSizeBounds(Rect * bounds);
		short			GetWindowType(void);
		void			GetWindowSize(Rect * theRect);
		void			GetWindowStandardSize(Rect * theRect);
		void			GetWindowContentPadding(Rect * theRect);
		
		virtual UInt32	GetItemWidth(void) = 0;
		virtual UInt32	GetItemHeight(void) = 0;
		virtual void	GetDefaultPosition(Point * where) = 0;
		virtual UInt32	GetInitialItemsShown(void) = 0;
		
		virtual UInt8	IsHorzResizable(void) = 0;
		virtual UInt8	SupportsSelection(void) = 0;
		
		virtual UInt8	GetDividerStatus(UInt32 id)	{ id = 0; return 0; }
		
		virtual UInt32	GetListLength(void) = 0;
		
		virtual void	SelectionChanged(void) { }
		
		virtual void	DrawElement(UInt32 id, SInt32 x, SInt32 y, UInt32 flags) = 0;
		void			DrawSimpleTextElement(SInt32 x, SInt32 y, StringPtr text, MTFontStyle * style);
		void			DrawSimpleTextElement(SInt32 x, SInt32 y, char * buf, MTFontStyle * style);
		
		virtual void	HandleListDoubleClick(UInt32 selection) = 0;
		
		UInt8			AutoHandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers);
		
		SInt32			selection;
	
	private:
		static const UInt32	kTextElementXOffset;
		static const UInt32	kTextElementYOffset;
};

#endif /* __MT_LIST_WINDOW_H__ */
